#!/bin/sh

# Copyright (c) 2018 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

appsupport-attach $CONFIG_INSTANCE /system/bin/sh -c "source /etc/mkshrc;
# make sure mobile data works
settings put global device_provisioned 1 || :
# allow automatic app rotation by default
settings put system accelerometer_rotation 1 || :
# fix autofill/perusersystemservices
settings put secure user_setup_complete 1 || :
# disable animations which break things
settings put global transition_animation_scale 0 || :
# disable bluetooth packages, these don't work and are only included so more apps show up in stores.
pm disable com.android.bluetooth 2>/dev/null || :
# enable memory reclaim to move unused memory to swap
device_config put activity_manager use_compaction true || :
# resizeable activities
settings put global force_resizable_activities 1 || :
# disable tethering
settings put global tether_supported 0 || :
setprop ro.tether.denied true || :
# trigger tasks that require systemd active state
setprop ro.appsupport.host_ready true || :
" || :

exit 0

