#!/bin/sh

# Copyright (c) 2018 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

if [ ! -d "$APPSUPPORT_DATA_ROOT/packaged" ]; then
    mkdir -p "$APPSUPPORT_DATA_ROOT/packaged"
fi

if [ ! -d $ANDROID_DATA_ROOT/data/aas-staging ] || [ "$(stat -c "%u" $ANDROID_DATA_ROOT/data/aas-staging)" != "0" ]; then
    # aas-staging directory has been accidentally removed, or shifted
    # by upgrade to unprivileged container, fix directories and permissions.
    mkdir -p $ANDROID_DATA_ROOT/data/aas-staging/app/incoming
    chown root:root $ANDROID_DATA_ROOT/data/aas-staging
    chmod 755 $ANDROID_DATA_ROOT/data/aas-staging
    chown root:privileged $ANDROID_DATA_ROOT/data/aas-staging/app
    chmod 775 $ANDROID_DATA_ROOT/data/aas-staging/app
    chown $APPSUPPORT_USER:privileged $ANDROID_DATA_ROOT/data/aas-staging/app/incoming
    chmod 775 $ANDROID_DATA_ROOT/data/aas-staging/app/incoming
fi
