#!/bin/sh

# Copyright (c) 2021 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

OUTPUT_FILE="$CONTAINER_CONFIG_PATH/20-privilege_config"

if [ "$PRIVILEGED" = "0" ]; then
    MAX_UIDS=200000
    FIRST_LENGTH=$(expr $APPSUPPORT_USER_UID - 1)
    AFTER_APPSUPPORT_USER_UID=$(expr $APPSUPPORT_USER_UID + 1)
    MAP_AFTER_APPSUPPORT_USER_UID=$(expr $APPSUPPORT_USER_UID + 1 + $APPSUPPORT_BASE_UID)
    LAST_LENGTH=$(expr $MAX_UIDS - $APPSUPPORT_USER_UID - 1)

    SECCOMP_FILE=aas-seccomp-profile
    KERNEL_MAJOR="$(uname -r | cut -d"." -f1)"
    KERNEL_MINOR="$(uname -r | cut -d"." -f2)"

    if [ "$KERNEL_MAJOR" -lt 6 ]; then
        if [ "$KERNEL_MAJOR" != 5 ] || [ "$KERNEL_MINOR" -lt 11 ]; then
            SECCOMP_FILE=aas-seccomp-profile-userfaultfd
        fi
    fi

    echo "lxc.seccomp.profile = $BASE_CONFIG_PATH/$SECCOMP_FILE
lxc.seccomp.allow_nesting = 1
lxc.cap.drop = linux_immutable ipc_owner sys_module sys_rawio sys_pacct sys_boot sys_time lease audit_write setfcap mac_override mac_admin audit_read
lxc.idmap = u 0 $APPSUPPORT_BASE_UID $FIRST_LENGTH
lxc.idmap = g 0 $APPSUPPORT_BASE_UID $FIRST_LENGTH
lxc.idmap = u $APPSUPPORT_USER_UID $APPSUPPORT_USER_UID 1
lxc.idmap = g $APPSUPPORT_USER_UID $APPSUPPORT_USER_UID 1
lxc.idmap = u $AFTER_APPSUPPORT_USER_UID $MAP_AFTER_APPSUPPORT_USER_UID $LAST_LENGTH
lxc.idmap = g $AFTER_APPSUPPORT_USER_UID $MAP_AFTER_APPSUPPORT_USER_UID $LAST_LENGTH
" > $OUTPUT_FILE
fi

exit 0

