#!/bin/sh

do_shift_uids() {
    _SHIFT_DIRECTORY="$1"
    _SHIFT_DIRECTION="$2"
    _SHIFT_UID="$3"
    _TMP_FILES="/tmp/appsupport_shift_uids.$$"

    while [ -f "$_TMP_FILES" ]; do
        _TMP_FILES="${_TMP_FILES}.0"
    done

    find $_SHIFT_DIRECTORY \! -type l -mindepth 1 -not -path "*/.android/data/aas-staging*" > $_TMP_FILES
    if [ $? -ne 0 ]; then
        echo "Failed to shift $_SHIFT_DIRECTION $_SHIFT_DIRECTORY files (find failed)." >&2
        exit 1
    fi

    $(appsupport-config --shift) $_SHIFT_DIRECTION $_SHIFT_UID < $_TMP_FILES
    if [ $? -ne 0 ]; then
        echo "Failed to shift $_SHIFT_DIRECTION $_SHIFT_DIRECTORY files (shift_uids failed)." >&2
        exit 1
    fi

    if [ "$_SHIFT_DIRECTION" = "up" ]; then
        echo "$_SHIFT_UID" > "$_SHIFT_DIRECTORY/.privilege_migration_done"
    else
        rm -f "$_SHIFT_DIRECTORY/.privilege_migration_done"
    fi

    rm -f $_TMP_FILES
}

if [ "$PRIVILEGED" = "1" ]; then
    if [ -f "$ANDROID_DATA_ROOT/.privilege_migration_done" ]; then
        APPSUPPORT_FILES_BASE_UID=$(cat "$ANDROID_DATA_ROOT/.privilege_migration_done")
        do_shift_uids $ANDROID_DATA_ROOT down $APPSUPPORT_FILES_BASE_UID
    fi
    if [ -f "$APPSUPPORT_USER_HOME/android_storage/.privilege_migration_done" ]; then
        APPSUPPORT_FILES_BASE_UID=$(cat "$APPSUPPORT_USER_HOME/android_storage/.privilege_migration_done")
        do_shift_uids $APPSUPPORT_USER_HOME/android_storage down $APPSUPPORT_FILES_BASE_UID
    fi
elif [ "$PRIVILEGED" = "0" ]; then
    if [ -d "$ANDROID_DATA_ROOT" ] &&
       [ ! -f "$ANDROID_DATA_ROOT/.privilege_migration_done" ]; then
        do_shift_uids $ANDROID_DATA_ROOT up $APPSUPPORT_BASE_UID
    fi
    if [ -d "$APPSUPPORT_USER_HOME/android_storage" ] &&
       [ ! -f "$APPSUPPORT_USER_HOME/android_storage/.privilege_migration_done" ]; then
        do_shift_uids $APPSUPPORT_USER_HOME/android_storage up $APPSUPPORT_BASE_UID
    fi
fi

