#!/bin/sh
# setup binder device nodes for devices with binderfs
#
# Copyright (c) 2021 - 2023 Jolla Ltd.
#
# License: Jolla Proprietary

# check if binderfs is supported by kernel
if grep -q binder /proc/filesystems
then
    if [ ! -e "/dev/binderfs" ]
    then
        mkdir -p /dev/binderfs
        mount -t binder binder /dev/binderfs
    fi

    if [ -e "/dev/binderfs" ] && /usr/libexec/appsupport/appsupport-run --exists binder-add 1>/dev/null
    then
        for key in BinderDev HwBinderDev VndBinderDev
        do
            devicenode=$($APPSUPPORT_PARSE_CONFIG --group Devices --key "$key")
            if [ "${devicenode#/}" = "$devicenode" ]
            then
                devicenode="/dev/$devicenode"
            fi
            file=$(basename "$devicenode")
            if [ ! -e "/dev/binderfs/$file" ]
            then
                /usr/libexec/appsupport/appsupport-run binder-add "$file"
            fi
            if [ ! -e "$devicenode" ]
            then
                ln -s "/dev/binderfs/$file" "$devicenode"
            fi
            chmod 666 "/dev/binderfs/$file"
        done
    fi
fi
