import QtQuick 2.6
import Sailfish.Silica 1.0
import Nemo.DBus 2.0
import com.jolla.apkd 1.0
import com.jolla.settings 1.0

SettingsToggle {
    id: appSupportToggle

    property string state

    //% "AppSupport"
    name: qsTrId("android_settings-short")
    icon.source: 'image://theme/icon-m-android'
    checked: state == "activating" || state == "deactivating" || state == "active"
    busy: state == "activating" || state == "deactivating"

    onToggled: {
        apkInterface.typedCall("controlService", [
                        { "type": "b", "value": !(checked) },
                        { "type": "s", "value": AppUtils.currentUser }
                    ])
    }

    menu: ContextMenu {
        SettingsMenuItem {
            onClicked: appSupportToggle.goToSettings()
        }
    }

    DBusInterface {
        id: apkInterface

        bus: DBus.SystemBus
        service: "com.jolla.apkd.control"
        path: "/com/jolla/apkd"
        iface: "com.jolla.apkd.control"
    }

    DBusInterface {
        id: appSupportService

        bus: DBus.SystemBus
        service: "org.freedesktop.systemd1"
        iface: "org.freedesktop.systemd1.Unit"
        signalsEnabled: true

        function updateProperties() {
            if (path !== "") {
                appSupportToggle.state= appSupportService.getProperty("ActiveState")
            } else {
                appSupportToggle.state = ""
            }
        }

        onPropertiesChanged: updateProperties()
        onPathChanged: updateProperties()
    }

   Timer {
        // stopping service can result in unit appearing and disappearing, for some reason.
        id: pathUpdateTimer

        interval: 100
        onTriggered: manager.updatePath()
    }

    DBusInterface {
        id: manager

        bus: DBus.SystemBus
        service: "org.freedesktop.systemd1"
        path: "/org/freedesktop/systemd1"
        iface: "org.freedesktop.systemd1.Manager"
        signalsEnabled: true
        signal unitNew(string name)
        onUnitNew: {
            if (name == AppUtils.serviceName) {
                pathUpdateTimer.start()
            }
        }

        signal unitRemoved(string name)
        onUnitRemoved: {
            if (name == AppUtils.serviceName) {
                appSupportService.path = ""
                pathUpdateTimer.stop()
            }
        }

        function updatePath() {
            manager.typedCall("GetUnit", [{ "type": "s", "value": AppUtils.serviceName}],
                function(unit) {
                    appSupportService.path = unit
                }, function() {
                    appSupportService.path = ""
                })
        }

        Component.onCompleted: {
            updatePath()
        }
    }
}

