#!/bin/sh

# Copyright (c) 2018 - 2022 Jolla Ltd.
#
# License: Jolla Proprietary

CONFIG_PATH="$(appsupport-config --path)"

if [ -e $CONFIG_PATH/appsupport.user ]; then
   LAST_APPSUPPORT_USER=$(cat $CONFIG_PATH/appsupport.user)
fi

if [ "$LAST_APPSUPPORT_USER" = "" ]; then
    LAST_APPSUPPORT_USER=$APPSUPPORT_USER
fi

if [ ! -d $ANDROID_DATA_ROOT/data/aas-staging ] || [ "$(stat -c "%u" $ANDROID_DATA_ROOT/data/aas-staging)" != "0" ]; then
    # aas-staging directory has been accidentally removed, or shifted
    # by upgrade to unprivileged container, fix directories and permissions.
    mkdir -p $ANDROID_DATA_ROOT/data/aas-staging/app/packaged
    mkdir -p $ANDROID_DATA_ROOT/data/aas-staging/app/incoming
    chown root:root $ANDROID_DATA_ROOT/data/aas-staging
    chmod 755 $ANDROID_DATA_ROOT/data/aas-staging
    chown root:privileged $ANDROID_DATA_ROOT/data/aas-staging/app
    chmod 775 $ANDROID_DATA_ROOT/data/aas-staging/app
    chown $APPSUPPORT_USER:privileged $ANDROID_DATA_ROOT/data/aas-staging/app/incoming
    chmod 775 $ANDROID_DATA_ROOT/data/aas-staging/app/incoming
    chown root:root $ANDROID_DATA_ROOT/data/aas-staging/app/packaged
    chmod 755 $ANDROID_DATA_ROOT/data/aas-staging/app/packaged
fi

if [ "$LAST_APPSUPPORT_USER" != "$APPSUPPORT_USER" ]; then
    # user switch:
    # ensure apkd connects to the correct session bus
    systemctl restart apkd
fi

echo "$APPSUPPORT_USER" > $CONFIG_PATH/appsupport.user
