#!/bin/sh

# Copyright (c) 2022 Jolla Ltd.
#
# License: Jolla Proprietary

if [ -z "$ANDROID_EMULATED_STORAGE" ]; then
    ANDROID_EMULATED_STORAGE="$APPSUPPORT_USER_HOME/android_storage"
fi

MIGRATION_DONE="$ANDROID_EMULATED_STORAGE/.storage_migration_done"

if [ "$(appsupport-config --get-prop ro.build.version.sdk)" != "30" ] ||
   [ ! -d "$ANDROID_EMULATED_STORAGE" ] ||
   [ "$HOOK_SCRIPT_NAME" -ot "$MIGRATION_DONE" ]; then
    exit 0
fi


if [ "$APPSUPPORT_USER" != "root" ]; then
    # Make sure host user group can always access files in emulated storage
    APPSUPPORT_USER_GROUP=$(id -gn $APPSUPPORT_USER)
    setfacl -R -P -d -m group:$APPSUPPORT_USER_GROUP:rwx "$ANDROID_EMULATED_STORAGE"
    setfacl -R -P -m group:$APPSUPPORT_USER_GROUP:rwx "$ANDROID_EMULATED_STORAGE"
fi

MEDIA_RW_GID=$(( APPSUPPORT_BASE_UID + 1023 ))
EXT_DATA_RW_GID=$(( APPSUPPORT_BASE_UID + 1078 ))
EXT_OBB_RW_GID=$(( APPSUPPORT_BASE_UID + 1079 ))

cat "$ANDROID_DATA"/system/packages.list | while read line; do
    set -- $line

    APP=$1
    APP_ID=$2
    APP_UID=$(( APPSUPPORT_BASE_UID + APP_ID ))

    if [ "$APP" = "com.android.providers.media.module" ]; then
        chown -R $APP_UID:$MEDIA_RW_GID "$ANDROID_EMULATED_STORAGE/Android/media"
    fi

    APP_STORAGE_DATA="$ANDROID_EMULATED_STORAGE/Android/data/$APP"
    if [ -d "$APP_STORAGE_DATA" ]; then
        chown -R $APP_UID:$EXT_DATA_RW_GID "$APP_STORAGE_DATA"
    fi

    APP_STORAGE_OBB="$ANDROID_EMULATED_STORAGE/Android/obb/$APP"
    if [ -d "$APP_STORAGE_OBB" ]; then
        chown -R $APP_UID:$EXT_OBB_RW_GID "$APP_STORAGE_OBB"
    fi
done

touch "$MIGRATION_DONE"
