#!/bin/sh
# Sailfish OS 4.4.0 didn't set default_credentials_username

# exit script with error if any of the commands below exit with error
set -xe

if [ "$UID" = "0" ] || ! loginctl > /dev/null
then
    echo "Running as root or no user sessions available, rescheduling to run later."
    exit 1
fi

for id in $(ag-tool list-accounts | tail -n +3 | grep -E '^[0-9]+\s+sailfisheas-oauth\s+' | cut -d' ' -f1)
do
    EMAIL=$(ag-tool get-account "$id" "string:connection/emailaddress" | cut -d' ' -f3)
    ag-tool update-account "$id" "string:default_credentials_username=${EMAIL}"
done

exit 0
